# AI dla biznesu — minimalizuj koszty dzięki głębokiemu Q-learningowi
# Tworzenie mózgu z dropoutem

# Importowanie bibliotek
from keras.layers import Input, Dense, Dropout
from keras.models import Model
from keras.optimizers import Adam

# BUDOWANIE MÓZGU 

class Brain(object):
    
    # BUDOWANIE W PEŁNI POŁĄCZONEJ SIECI NEURONOWEJ WEWNĄTRZ METODY INIT
    
    def __init__(self, learning_rate = 0.001, number_actions = 5):
        self.learning_rate = learning_rate
        
        # BUDOWANIE WARSTWY WEJŚCIOWEJ ZŁOŻONEJ ZE STANÓW WEJŚCIOWYCH 
        states = Input(shape = (3,))
        
        # ZBUDOWANIE PIERWSZEJ W PEŁNI POŁĄCZONEJ UKRYTEJ WARSTWY Z AKTYWNYM DROPOUT
        x = Dense(units = 64, activation = 'sigmoid')(states)
        x = Dropout(rate = 0.1)(x)
        
        # ZBUDOWANIE DRUGIEJ W PEŁNI POŁĄCZONEJ UKRYTEJ WARSTWY Z AKTYWNYM DROPOUT
        y = Dense(units = 32, activation = 'sigmoid')(x)
        y = Dropout(rate = 0.1)(y)
        
        # ZBUDOWANIE WARSTWY WYJŚCIOWEJ, W PEŁNI POŁĄCZONEJ Z OSTATNIĄ UKRYTĄ WARSTWĄ
        q_values = Dense(units = number_actions, activation = 'softmax')(y)
        
        # MONTAŻ PEŁNEJ ARCHITEKTURY WEWNĄTRZ OBIEKTU MODEL
        self.model = Model(inputs = states, outputs = q_values)
        
        # KOMPILACJA MODELU Z BŁĘDEM ŚREDNIOKWADRATOWYM STRATY I WYBRANYM OPTYMALIZATOREM
        self.model.compile(loss = 'mse', optimizer = Adam(lr = learning_rate))
